<?php
/* --------------------------------------------------------------
   HubPayPalSettings.inc.php 2020-05-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

use HubPublic\Http\CurlRequest;

class HubPayPalSettings
{
    protected $config;

    public function __construct(HubPayPalConfiguration $configuration)
    {
        $this->config = $configuration;
    }

    protected function getJavascriptSource($position = 'cart')
    {
        if (!gm_get_conf('GAMBIO_HUB_REMOTE_CONFIG_PAYPAL2HUB_ECS')) {
            return ''; // The module is not installed.
        }

        $sessionKey = 'paypalhub-jssrc-' . $position;
        if (!empty($_SESSION[$sessionKey])) {
            return $_SESSION[$sessionKey];
        }

        $query = [
            'client_key' => gm_get_conf('GAMBIO_HUB_CLIENT_KEY'),
            'devmode'    => file_exists(DIR_FS_CATALOG . '/.dev-environment') ? 'true' : 'false',
        ];
        /** @var HubSettings $hubSettings */
        $hubSettings = MainFactory::create('HubSettings', gm_get_conf('GAMBIO_HUB_CURL_TIMEOUT'));

        /** @var \HubCallbackApiClient $hubCallbackApiClient */
        $hubCallbackApiClient = MainFactory::create(
            'HubCallbackApiClient',
            MODULE_PAYMENT_GAMBIO_HUB_URL,
            new CurlRequest(),
            LogControl::get_instance(),
            $hubSettings
        );

        $params = ['source' => 'get_javascript_source', 'position' => (string)$position];

        /** @var \HubPublic\ValueObjects\HttpResponse $response */
        try {
            $response = $hubCallbackApiClient->execute('PayPal2Hub', true, $params, $query);
        } catch(\UnexpectedValueException $e) {
            return '';
        }

        if ($response->getStatusCode() !== 200) {
            throw new RuntimeException('Error retrieving JS URL from hub');
        }
    
        $responseBody = json_decode($response->getBody(), true);
        if (!empty($responseBody['jssrc']) && is_array($responseBody) && json_last_error() === JSON_ERROR_NONE) {
            $src = $responseBody['jssrc'];
            $src .= '&currency=' . $_SESSION['currency'];
        } else {
            $src = '';
        }
        $_SESSION[$sessionKey] = $src;
    
        return $src;
    }
}
